<?php
session_start();

// Se já estiver logado, redirecionar diretamente para o painel
if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
    header('Location: admin_panel.php');
    exit();
}

// Credenciais de administrador
$valid_username = 'admin';
$valid_password = '@Redbones02';

$error = '';

// Processar formulário de login
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if ($username === $valid_username && $password === $valid_password) {
        $_SESSION['admin_logged_in'] = true;
        $_SESSION['admin_username'] = $username;
        $_SESSION['login_time'] = time();
        
        // Redirecionar para o painel
        header('Location: admin_panel.php');
        exit();
    } else {
        $error = "Credenciais inválidas!";
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Painel Admin</title>
    <style>
        :root {
            --neon-green: #00ff41;
            --dark-bg: #0d0d0d;
            --darker-bg: #1a1a1a;
        }
        
        body {
            font-family: 'Courier New', monospace;
            background-color: var(--dark-bg);
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            color: var(--neon-green);
        }
        
        .login-container {
            background: var(--darker-bg);
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 0 20px rgba(0, 255, 65, 0.3);
            width: 300px;
            text-align: center;
            border: 1px solid var(--neon-green);
        }
        
        h2 {
            text-align: center;
            margin-bottom: 20px;
            text-shadow: 0 0 10px var(--neon-green);
        }
        
        .form-group {
            margin-bottom: 15px;
            text-align: left;
        }
        
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        
        input[type="text"],
        input[type="password"] {
            width: 100%;
            padding: 10px;
            border: 1px solid var(--neon-green);
            border-radius: 4px;
            font-size: 16px;
            background-color: var(--dark-bg);
            color: var(--neon-green);
        }
        
        button {
            width: 100%;
            padding: 12px;
            background-color: var(--neon-green);
            color: var(--dark-bg);
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            font-weight: bold;
            transition: all 0.3s;
        }
        
        button:hover {
            background-color: #00cc33;
        }
        
        .error {
            color: #ff003c;
            text-align: center;
            margin-top: 10px;
            padding: 10px;
            background-color: rgba(255, 0, 60, 0.1);
            border-radius: 4px;
            border: 1px solid #ff003c;
        }
        
        .demo-credentials {
            margin-top: 20px;
            padding: 10px;
            background-color: rgba(0, 255, 65, 0.1);
            border-radius: 4px;
            border: 1px solid var(--neon-green);
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <h2>PAINEL ADMIN - LOGIN</h2>
        
        <?php if (!empty($error)): ?>
            <div class="error"><?php echo $error; ?></div>
        <?php endif; ?>
        
        <form method="POST">
            <div class="form-group">
                <label for="username">Usuário:</label>
                <input type="text" id="username" name="username" required autocomplete="off">
            </div>
            <div class="form-group">
                <label for="password">Senha:</label>
                <input type="password" id="password" name="password" required autocomplete="off">
            </div>
            <button type="submit">ACESSAR</button>
        </form>
        
        <div class="demo-credentials">
        
          
        </div>
    </div>
</body>
</html>