<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

// Configurações
$dataDir = 'sessions/';

// Obter session_id da query string
$sessionId = $_GET['session_id'] ?? '';

if (empty($sessionId)) {
    echo json_encode(['status' => 'error', 'message' => 'Session ID não fornecido']);
    exit;
}

$sessionFile = $dataDir . $sessionId . '.json';

if (!file_exists($sessionFile)) {
    echo json_encode(['status' => 'error', 'message' => 'Sessão não encontrada']);
    exit;
}

// Carregar dados da sessão
$sessionData = json_decode(file_get_contents($sessionFile), true);

// Verificar se há ações pendentes
if (!empty($sessionData['pending_actions'])) {
    // Obter a última ação pendente
    $lastAction = array_pop($sessionData['pending_actions']);
    
    // Atualizar arquivo de sessão
    file_put_contents($sessionFile, json_encode($sessionData, JSON_PRETTY_PRINT));
    
    echo json_encode([
        'status' => 'success',
        'action' => $lastAction
    ]);
} else {
    echo json_encode([
        'status' => 'success',
        'action' => null
    ]);
}
?>