<?php
header('Content-Type: application/json; charset=utf-8');

$dataDir = __DIR__ . '/sessions/';
$sessionId = isset($_GET['session_id']) ? preg_replace('/[^a-zA-Z0-9_\-]/','', $_GET['session_id']) : null;
if (!$sessionId) { echo json_encode([]); exit; }

$file = $dataDir . $sessionId . '.json';
if (!file_exists($file)) { echo json_encode([]); exit; }

$doc = json_decode(file_get_contents($file), true);
$actions = $doc['pending_actions'] ?? [];

// Consome ações
$doc['pending_actions'] = [];
file_put_contents($file, json_encode($doc, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE));

echo json_encode($actions);
